/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.item;

import cloud.lemonslice.teastory.recipe.drink.DrinkEffectManager;
import cloud.lemonslice.teastory.tag.TeaTags;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.registry.FluidRegistry;

public class CupDrinkItem
extends ItemFluidContainer {
    public CupDrinkItem(int capacity, Item.Properties name) {
        super(name, capacity);
    }

    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack(stack, this.capacity){

            @Nonnull
            public ItemStack getContainer() {
                return this.getFluid().isEmpty() ? new ItemStack((ItemLike)CupDrinkItem.this.m_41469_()) : this.container;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return stack.getFluid().m_205067_(TeaTags.Fluids.DRINK);
            }
        };
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41784_().m_128441_("Fluid")) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(f -> tooltip.add((Component)MutableComponent.m_237204_((ComponentContents)f.getFluidInTank(0).getDisplayName().m_214077_()).m_130946_(String.format(": %d / %dmB", f.getFluidInTank(0).getAmount(), this.capacity)).m_130940_(ChatFormatting.GRAY)));
        }
    }

    public void fillItemGroup(CreativeModeTab.Output group) {
        for (RegistryObject fluid : FluidRegistry.FLUIDS.getEntries()) {
            if (!(fluid.get() instanceof ForgeFlowingFluid.Source)) continue;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            CompoundTag fluidTag = new CompoundTag();
            new FluidStack((Fluid)fluid.get(), this.capacity).writeToNBT(fluidTag);
            itemStack.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
            group.m_246342_(itemStack);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return CupDrinkItem.canDrink(stack) ? UseAnim.DRINK : UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return CupDrinkItem.canDrink(stack) ? 32 : 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (CupDrinkItem.canDrink(stack)) {
            playerIn.m_6672_(handIn);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (CupDrinkItem.canDrink(stack)) {
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), entityLiving.m_7866_(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (worldIn.m_213780_().m_188501_() - worldIn.m_213780_().m_188501_()) * 0.4f);
            FluidUtil.getFluidContained((ItemStack)stack).ifPresent(handler -> {
                BiConsumer<LivingEntity, Integer> action = DrinkEffectManager.getEffects(handler.getFluid());
                if (action != null) {
                    action.accept(entityLiving, handler.getAmount());
                } else if (entityLiving instanceof Player && handler.getFluid() != FluidRegistry.BOILING_WATER_STILL.get()) {
                    FoodData foodata = ((Player)entityLiving).m_36324_();
                    ((Player)entityLiving).m_36324_().m_38705_(foodata.m_38702_() + (int)(1.2f * (float)this.capacity / 100.0f));
                    ((Player)entityLiving).m_36324_().m_38717_(foodata.m_38722_() + 0.4f);
                }
            });
            if (entityLiving instanceof Player) {
                ItemHandlerHelper.giveItemToPlayer((Player)((Player)entityLiving), (ItemStack)new ItemStack((ItemLike)this.m_41469_()));
            }
            stack.m_41774_(1);
        }
        return stack;
    }

    public static boolean canDrink(ItemStack stack) {
        if (stack.m_41784_().m_128441_("Fluid")) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(f -> f.getFluid().m_205067_(TeaTags.Fluids.DRINK)).orElse(false);
        }
        return false;
    }
}

